% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avoid.R
\name{avoid}
\alias{avoid}
\alias{avoid,numeric-method}
\alias{avoid,xy-method}
\title{Avoid overlaps}
\usage{
avoid(x, ...)

\S4method{avoid}{numeric}(
  x,
  y,
  ...,
  xlog = par("xlog"),
  ylog = par("ylog"),
  usr = par("usr"),
  pin = par("pin"),
  eps = .Machine$double.eps,
  pi = base::pi
)

\S4method{avoid}{xy}(x, ...)
}
\arguments{
\item{x, y}{any of the forms that the coordinates of a scatterplot may be specified}

\item{...}{additional arguments for methods}

\item{xlog, ylog}{logicals: are the x- and/or y-scales logarithmic?}

\item{usr, pin}{graphics parameters \code{par("usr"), par("pin")} (or replacements)}

\item{eps}{numeric: a zero tolerance}

\item{pi}{numeric: the value of the arithmetic constant of the same name}
}
\value{
a vector of integers all of which are 1, 2, 3, or 4, indicating placement positions.
}
\description{
Generate a vector of positions to use to minimise text overlaps in labelled scatterplots
}
\examples{
set.seed(123)
z <- complex(real = runif(50), imaginary = runif(50))
mz <- mean(z)
z <- z[order(Arg(z - mz))]
plot(z, axes = FALSE, ann = FALSE)
segments(Re(mz), Im(mz), Re(z), Im(z))
abline(h = Im(mz), v = Re(mz), lwd = 0.5)
box()
text(Re(z), Im(z), pos = avoid(z), cex = 0.7, offset = 0.25,
     col = "red", font = 2, xpd = NA)
}
