% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{mbnma.write}
\alias{mbnma.write}
\title{Write MBNMA dose-response model JAGS code}
\usage{
mbnma.write(
  fun = "linear",
  beta.1 = "rel",
  beta.2 = NULL,
  beta.3 = NULL,
  beta.4 = NULL,
  method = "common",
  knots = 3,
  cor = TRUE,
  cor.prior = "wishart",
  var.scale = NULL,
  class.effect = list(),
  UME = FALSE,
  user.fun = NULL,
  likelihood = "binomial",
  link = NULL
)
}
\arguments{
\item{fun}{A character vector specifying a functional form to be assigned to the
dose-response. Options are given in \code{details}.}

\item{beta.1}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.2}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.3}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.4}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{knots}{The number/location of knots if a restricted cubic spline dose-response function is fitted (\code{fun="rcs"}).
If a single number is given it indicates the number of knots (they will
be equally spaced across the range of doses). If a numeric vector is given it indicates the location of the knots.
Minimum number of knots is 3.}

\item{cor}{A boolean object that indicates whether correlation should be modelled
between relative effect dose-response parameters (\code{TRUE}) or not (\code{FALSE}). This is
automatically set to \code{FALSE} if class effects are modelled or if multiple dose-response
functions are fitted.}

\item{cor.prior}{NOT CURRENTLY IN USE - indicates the prior distribution to use for the correlation/covariance
between relative effects. Must be kept as \code{"wishart"}}

\item{var.scale}{A numeric vector indicating the relative scale of variances between
correlated dose-response parameters when relative effects are modelled on more than
one dose-response parameter and \code{cor=TRUE} (see details). Each element of
the vector refers to the relative scale of each of the dose-response parameters that is
modelled using relative effects.}

\item{class.effect}{A list of named strings that determines which dose-response
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). Element names should match dose-response parameter names (which will therefore
depend on whether or not a wrapper function has been used for \code{mbnma.run()}).
For example: \code{list("beta.2"="fixed", "beta.3"="random")} when using
\code{mbnma.run()} or \code{list("ed50"="fixed", "hill"="random")} when using \code{mbnma.emax.hill()}.}

\item{UME}{A boolean object to indicate whether to fit an Unrelated Mean Effects model
that does not assume consistency and so can be used to test if the consistency
assumption is valid.}

\item{user.fun}{A formula specifying any relationship including \code{dose} and
one/several of: \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}) or be assigned the value \code{"identity"} for
and identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}
}
\value{
A single long character string containing the JAGS model generated
based on the arguments passed to the function.
}
\description{
Writes JAGS code for a Bayesian time-course model for model-based network
meta-analysis (MBNMA).
}
\details{
When relative effects are modelled on more than one dose-response parameter and
\code{cor = TRUE}, correlation between the dose-response parameters is automatically
estimated using a vague Wishart prior. This prior can be made slightly more informative
by specifying the relative scale of variances between the dose-response parameters using
\code{var.scale}. \code{cor} will automatically be set to \code{FALSE} if class effects are modelled or
if a model is fitted with multiple dose-response functions.
}
\examples{
# Write model code for a model with an exponential dose-response function,
# relative effects modelled on the rate of growth/decay (beta.1) with a random
# effects model
model <- mbnma.write(fun="exponential",
             beta.1="rel",
             method="random",
             likelihood="binomial",
             link="logit"
             )
cat(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax (beta.1) with a random effects model,
# a single parameter estimated for ED50 (beta.2) with a common effects model
model <- mbnma.write(fun="emax",
             beta.1="rel",
             beta.2="common",
             likelihood="normal",
             link="identity"
             )
cat(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax (beta.1) and ED50 (beta.2).
# Class effects modelled on ED50 with common effects
model <- mbnma.write(fun="emax",
             beta.1="rel",
             beta.2="rel",
             likelihood="normal",
             link="identity",
             class.effect=list("beta.2"="common")
             )
cat(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax (beta.1) and ED50 (beta.2) with a
# random effects model that automatically models a correlation between
# both parameters.
model <- mbnma.write(fun="emax",
             beta.1="rel",
             beta.2="rel",
             method="random",
             likelihood="normal",
             link="identity",
             )
cat(model)
}
