# MBNMAdose 0.4.2

## Additions/changes
- Reference SDs can now be used when modelling using SMDs to avoid using study-specific SDs, which can be problematic.
- Network Meta-Regression: Effect modifiers can now be incorporated using `regress.vars` argument in `mbnma.run()`. Various sharing assumptions for effects can be specified in `regress.effect`.
- Predictions can be estimated for class effect models
- Fractional polynomial powers in `dfpoly()` can only take numeric values from set defined in Jansen 2015.
- Added `calc.edx()` to allow easy estimation of different ED values (e.g. ED90 = the dose at which 90% of the 
maximum response (Emax) is reached)
- `get.relative()` now allows simultaneous comparison of two models in a single league table - can be used to compare MBNMA models with different dose-response functions, or MBNMA and NMA models, or NMA models that assume consistency versus those that use Unrelated Mean Effects.
- Plots of predictions look prettier
- Dose-response parameters that were previously modelled on an exponential scale (`ed50`, `hill`, `onset`) are now on the natural scale and are assigned truncated normal default priors
- Separate prior distributions can be specified for different indices of a parameter - allows for agent-specific prior distributions on dose-response parameters.

## Bug fixes
- Fixed issue with duplication of studyIDs in `getjagsdata()`
- Fixed bug with studyID labels in `fitplot()` and `devplot()`
- Fixed issue and documentation with splines to highlight that knot limits should not be specified

# MBNMAdose 0.4.1

## Additions/changes

- Added `get.relative()` to allow estimation of relative effects between any doses of different agents.
- Adding ranking for `"relative.array"` objects generated by `get.relative()`.
- Agent-specific dose-response functions run more smoothly. Can now incorporate splines with different knots
- Number of responders should now be included in dataset as `n` rather than `N` so that datasets can be consistent with those used in `MBNMAtime`
- Simplified names of datasets included in the package
- Prediction intervals can be calculated in addition to credible intervals (the default) for `predict.mbnma()` and `get.relative()`
- Added `devdev()` for comparing deviance contributions between models

## Bug fixes
- Fixed issue with agent-specific dose-response functions that had different spline knot locations
- Fixed bug that cut out the wrong sections of JAGS output based on incorrect indexing of agent-specific dose-response functions


# MBNMAdose 0.4.0

## Additions/changes

- Dose-response functions provided to `mbnma.run()` are now given as `class("dosefun")` and dose-response parameters are specified within these functions. NOTE: Previous syntax of specifying a function name as a character (e.g. `fun="linear"`) along with beta parameters (e.g. `mbnma.run(beta.1="rel")`) will be removed in subsequent versions, along with wrapper functions.
- Added log linear dose-response function (`dloglin()`)
- Added spline function (`dspline()`) (piecewise linear splines, B-splines, restricted cubic splines, natural splines)
- Added fractional polynomial function (`dfpoly()`)
- Agent-specific dose-response functions work with all other functions (e.g. ranking, nodesplit, prediction)
- Added `link="smd"` to allow for analysis using Standardised Mean Differences
- Uses `calcom()` to guess outcome measure scale for more careful specification of default priors for SD
- Study IDs added to `"mbnma.network"` object


## Bug fixes
- Error with running random effects models in `mbnma.nodesplit()` fixed


# MBNMAdose 0.3.1

## Bug fixes

- Spline functions also return doses as well as spline basis matrices in jagsdata
- Added informative error for if `params` in `plot.mbnma.rank()` is not a subset of `x`


## Additions/changes

- Updated and simplified package structure plot in README file
- `overlay.split()` uses full distribution of `E0` rather than summary statistics
- `mbnma.predict` object now contains values assigned/estimated for `E0` to be used in `overlay.split()`
- In `plot.nodesplit()`, `plot.type="forest"` plots a single forest plot with results for each node-split comparison, rather than presenting results in panels.


# MBNMAdose 0.3.0

## Bug fixes

- Ensured `summary.mbnma.network()` returns valid minimum doses per agent
- Ensured models run in parallel when `parallel=TRUE` and added a warning when `pd` is set to `"pd.kl"` or `"popt"` for these models.
- Ensured results are printed properly for each parameter when using `summary()` for multiple dose-response function models

## Additions/changes

- Added restricted cubic spline dose-response function (`fun="rcs"`) in `mbnma.run()`
- Unrelated mean effects (UME) model now added to `mbnma.run()` to allow relaxing of the consistency assumption. This can be used to test its validity.
- `cumrank()` added for cumulative ranking plots. Also calculates SUCRA values for each agent and dose-response parameter
- `autojags` options added for `mbnma.run()` to allow users to run models until they converge (convergence defined by `Rhat`)
- `rank.mbnma()` also calculates cumulative ranking probabilities and stores them in `cum.matrix`
- Data from `getjagsdata()` contains `studyID` and has been added to `mbnma` objects
- Added studyID column to output from `devplot()` and `fitplot()`
- `plot.nodesplit()` scales y-axis if density is >50 times larger in panel with highest density than in panel with lowest density. This improves legibility of the graph.
- All nodesplit models now return object of `class("nodesplit")`
- `mbnma.nodesplit()` includes potential splits via dose-response curve and direct and indirect evidence contributions are calculated simultaneously in the same model.
- Corrected calculation for Bayesian p-value in `mbnma.nodesplit()` and `nma.nodesplit()`
- Added legend options to `plot.mbnma.network()`
- Added `psoriasis` and `ssri` datasets to package
- Used `crayon` package to neaten printed console outputs

# MBNMAdose 0.2.7

## Bug fixes
 
- Ensured stringsAsFactors = FALSE does not affect package in preparation for R 4.0.0.
- Edited tests to ensure that any checks for matrix objects account for matrix objects now having matrix and array classes
- Allowed number of responders for binomial data to be greater than or equal to zero (rather than greater than zero)


# MBNMAdose 0.2.6

## Additions/Changes

- Ensured non-parametric functions are properly monotonic by setting default initial values. Each agent now includes an index dose level of 1, which corresponds to the reference treatment effect (placebo)



# MBNMAdose 0.2.5

## Additions/Changes

- Added Lujin Li to list of authors as a reviewer thanks to his considerable help in identifying issues in the previous version.
- Each agent can be assigned a different dose-response function (by assigning a vector of functions to `fun` in `mbnma.run()`) so that multiple functions can be modelled simultaneously. Some downstream package functions still may not yet work with these models though.
- `mbnma.network` objects returned from `plot.mbnma.network` now have specific igraph attributes assigned to them, which can be easily changed by the user.
- `user.fun` now takes a formula as an argument (for example `~ (beta.1 * dose) + (beta.2 * dose^2)`) rather than a string.
- `plot.mbnma.network()` now uses a `layout` argument that takes an igraph layout function instead of `layout_in_circle` (which was a logical argument). This allows any igraph layout to be plotted rather than just a circle (e.g. `igraph::as_star()`)


## Bug fixes

- Changed `if {class(x)=="matrix"}` statements to `if {is.matrix(x)}` to address R development changes


### Major
- Exponential function models were not working previously but the dose-response function has been rewritten so that it runs the model correctly.
- DIC reported correctly in output when using plugin (`pd="plugin"`), or Kullback-Leibler divergence (`pd="pd.kl"`)
- Using the argument `parallel=TRUE` in `mbnma.run()` (or wrapper functions) now properly runs JAGS in parallel on multiple cores.

### Minor
- Downstream mbnma-related objects now store `mbnma.network` in their output rather than just treatment and agent names.


# MBNMAdose 0.2.4

## Documentation changes

- Update to README to ensure package workflow image works correctly on CRAN.
- Added JAGS as a System Requirement (JAGS >= 4.3.0) to the DESCRIPTION

## Bug fixes

### Major
- Fixed incorrect ordering of treatment codes in mbnma.network, which also led to problems in subsequent commands/plots

### Minor
- Fixed minor with numeric vs character coding of treatments in arguments for ranking functions
- Fixed issue with `nma.nodesplit()` that prevented the model running if disconnected treatments were included in the analysis (`drop.discon=FALSE`)


# MBNMAdose 0.2.3

## Documentation changes

- Made corrections to some arguments specified in documentation
- Fixed incorrect vignette reference
- Allowed more examples in the vignette to run so that plots can be created which better illustrates how MBNMA.run() functions are used.


# MBNMAdose 0.2.2

## First release of package

Welcome to MBNMAdose. Ready for release into the world. I hope it can be of service to you! For time-course MBNMA, also check out the sister package, MBNMAtime.
