% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{replace.prior}
\alias{replace.prior}
\title{Replace original priors in an MBNMA model with new priors}
\usage{
replace.prior(priors, model = NULL, mbnma = NULL)
}
\arguments{
\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax}.}

\item{model}{A character object of JAGS MBNMA model code}

\item{mbnma}{An S3 object of class \code{c("mbnma", "rjags")} generated by running a
time-course MBNMA model.}
}
\value{
A character object of JAGS MBNMA model code that includes the new
priors in place of original priors
}
\description{
Identical to \code{replace.prior()} in MBNMAdose.
}
\details{
This function takes new priors, as specified by the user, and adds them to
the JAGS code from an MBNMA model. New priors replace old priors in the JAGS
model.

Values in \code{priors} can include any JAGS functions/distributions
(e.g. censoring/truncation).
}
