% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{hyalarthritis}
\alias{hyalarthritis}
\title{Studies comparing hyaluronan (HA)–based viscosupplements for osteoarthritis}
\format{
A data frame in long format (one row per arm and study), with 150 rows and 6 variables:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating the time at which the observation was measured (given in weeks)
\item \code{treatment} Factor data indicating the treatment to which participants were randomised
\item \code{n} Numeric data indicating the number of participants randomised to each arm
\item \code{y} Numeric data indicating the mean change from baseline in HbA1c in a study arm
\item \code{se} Numeric data indicating the standard error for the mean change from baseline in HbA1c in a study arm
}
}
\usage{
hyalarthritis
}
\description{
A dataset from of trials for pain reduction for patients with
osteoarthritis treated with HA-based viscosupplements\insertCite{jansen2015}{MBNMAtime}.
Data are reported in each study arm as mean change from baseline to follow-up
on a visual analogue scale (0-100).
The dataset includes 16 Randomised-Controlled Trials (RCTs), comparing 6 treatments
and placebo.
}
\details{
\code{hyalarthritis} is a data frame in long format (one row per observation, arm and study),
with the variables \code{studyID}, \code{time}, \code{treatment}, \code{n}, \code{y}, and \code{se}.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
