% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.functions.R
\name{inconsistency.loops}
\alias{inconsistency.loops}
\title{Identify comparisons in loops that fulfil criteria for node-splitting}
\usage{
inconsistency.loops(data)
}
\arguments{
\item{data}{A data frame containing variables \code{studyID} and \code{treatment} (as
numeric codes) that indicate which treatments are used in which studies.}
}
\value{
A data frame of comparisons that are informed by direct and indirect
evidence from independent sources. Each row of the data frame is a
different treatment comparison. Numerical codes in \code{t1} and \code{t2} correspond
to treatment codes.
}
\description{
Identify comparisons informed by both direct and indirect evidence from
independent sources, which therefore fulfil the criteria for testing for
inconsistency via node-splitting. Follows the method of van Valkenhoef \insertCite{vanvalkenhoef2016;textual}{MBNMAtime}.
}
\details{
Similar to \code{gemtc::mtc.nodesplit()} but uses a fixed
reference treatment and therefore suggests fewer loops in which to test for
inconsistency. Heterogeneity can also be parameterised as inconsistency and
so testing for inconsistency in additional loops whilst changing the
reference treatment would also be identifying heterogeneity. Depends on \code{\link[igraph]{igraph}}.
}
\examples{
data <- data.frame(studyID=c(1,1,2,2,3,3,4,4,5,5,5),
  treatment=c(1,2,1,3,2,3,3,4,1,2,4)
  )

# Identify comparisons informed by direct and indirect evidence
inconsistency.loops(data)
}
\references{
\insertAllCited{}
}
