% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{tloglin}
\alias{tloglin}
\title{Log-linear (exponential) time-course function}
\usage{
tloglin(pool.rate = "rel", method.rate = "common")
}
\arguments{
\item{pool.rate}{Pooling for rate parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.rate}{Method for synthesis of rate parameter. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}
}
\value{
An object of \code{class("timefun")}
}
\description{
\eqn{rate\times{log(x + 1)}}
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this time-course parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific time-course parameters (e.g. Hill parameters in Emax functions, power parameters in fractional polynomials) to a single value. \cr
}
}

\examples{
tloglin(pool.rate="rel", method.rate="random")
tloglin(pool.rate="abs")

}
\references{
\insertAllCited
}
