% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tstopslookup.R
\name{Tstopslookup}
\alias{Tstopslookup}
\title{Search for information on a stop with a given name. Useful when stop_id is not known.}
\usage{
Tstopslookup(stop_name)
}
\arguments{
\item{stop_name}{Name of stop to search for.}
}
\value{
Dataframe with row for each potential matching stop and the following columns:
\item{route_id}{GTFS-compatible route_id for the stop match.}
\item{direction_id}{Direction ID (0/1)}
\item{direction_name}{Human-readable direction identifier}
\item{stop_order}{Order in given direction of stop}
\item{stop_id}{GTFS-compatible ID of stop}
\item{stop_name}{Name of stop}
\item{parent_station}{Parent station GTFS-compatible ID}
\item{parent_station_name}{Parent station name}
\item{stop_lat}{Stop latitude}
\item{stop_lon}{Stop longitude}
}
\description{
Search for information on a stop with a given name. Useful when stop_id is not known.
}
\examples{
\dontrun{
Tstopslookup(stop_name = "Mattapan") # this would take a long tiem (~70 seconds) so is left out here
}
}
