\name{MDM-package}
\alias{MDM-package}
\alias{MDM}
\docType{package}
\title{Multinomial Diversity Model}
\description{The multinomial diversity model is a toolbox for relating diversity
to complex predictors. It is based on (1) Shannon diversity; (2) the multinomial logit model,
and (3) the link between Shannon diversity and the log-likelihood of the MLM.
}
\details{
\tabular{ll}{
Package: \tab MDM\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2011-09-08\cr
License: \tab GPL (version 2 or newer)\cr
LazyLoad: \tab yes\cr
}
}
\author{Glenn De'ath: \email{g.death@aims.gov.au}}
\references{
De'ath, G. (2011) \emph{The Multinomial Diversity Model: Linking Shannon Diversity
To Multiple Predictors}
}
\keyword{diversity}
\examples{
library(MDM)
data(spider6)
fit0 <- mdm(y2p(spider6[,1:6])~1,data=spider6)
fit1 <- mdm(y2p(spider6[,1:6])~Water,data=spider6)
fit2 <- mdm(y2p(spider6[,1:6])~Water+Herbs,data=spider6)
fit3 <- mdm(y2p(spider6[,1:6])~Site,data=spider6,alpha=TRUE)
anova(fit0,fit1,fit2,fit3)
}
