% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdmr.R
\name{summary.mdmr}
\alias{summary.mdmr}
\title{Summarizing MDMR Results}
\usage{
\method{summary}{mdmr}(object, ...)
}
\arguments{
\item{object}{Output from \code{mdmr}}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\item{Statistic}{Value of the corresponding MDMR test statistic}
\item{Pseudo R2}{Effect size of the corresponding effect on the
distance matrix}
\item{p-value}{Analytical p-value}
}
\description{
\code{summary} method for class \code{mdmr}
}
\examples{
# --- The following two approaches yield equivalent results --- #
# Approach 1
data(mdmrdata)
D <- dist(Y.mdmr, method = 'euclidean')
mdmr.res <- mdmr(X = X.mdmr, D = D)
summary(mdmr.res)

}
\author{
\packageAuthor{MDMR}
}
\references{
Davies, R. B. (1980). The Distribution of a Linear Combination of
 chi-square Random Variables. Journal of the Royal Statistical Society.
 Series C (Applied Statistics), 29(3), 323-333.

 Duchesne, P., & De Micheaux, P.L. (2010). Computing the distribution of
 quadratic forms: Further comparisons between the Liu-Tang-Zhang
 approximation and exact methods. Computational Statistics and Data
 Analysis, 54(4), 858-862.

 McArtor, D.B. & Lubke, G.H. (submitted). Extending multivariate distance
 matrix regression with an effect size measure and the distribution of the
 test statistic.
}

