% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{convert.polar}
\alias{convert.polar}
\title{Convert Cartesian coordinates from wMDS coordinates to polar coordinates.}
\usage{
convert.polar(mdsobject, nloci)
}
\arguments{
\item{mdsobject}{Output from \code{\link[smacof]{smacofSphere}} using the dual method in the \pkg{smacof} package.}

\item{nloci}{The number of markers in the configuration.}
}
\value{
\item{theta}{A vector of angles one for each point.}
\item{radius}{A scalar the radius of sphere.}
}
\description{
Converts the coordinates of points in the final configuration of a spherically 
constrained wMDS from Cartesian to polar coordinates.
}
\details{
Centres the circle on zero if necessary, finds a the most natural break in 
the points to start as 0, then calculates the angle of each point relative 
to this. The radius is the median distance of points from the centre.
}
\examples{
#M and lod should be n x n symmetric matrices of the same dimensions where n 
#is the number markers to be analysed
\dontrun{
mds1<-smacofSphere(M,ndim=2,algorithm="dual",weightmat=lod,penalty=100)
pol<-convert.polar(mds1,n)
}
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF in R. J Stat Softw 31:1-30} \url{http://www.jstatsoft.org/v31/i03/}
}
\seealso{
\code{\link[smacof]{smacofSphere}}
}
