\name{MFr}
\alias{MFr}
\title{Mitigated fraction}
\usage{
  MFr(formula, data, compare = c("con", "vac"))
}
\arguments{
  \item{formula}{Formula of the form \code{y ~ x}, where y
  is a continuous response and x is a factor with two
  levels}

  \item{data}{Data frame}

  \item{compare}{Text vector stating the factor levels --
  \code{compare[1]} is the control or reference group to
  which \code{compare[2]} is compared}
}
\value{
  The estimated mitigated fraction.
}
\description{
  Mitigated fraction comparing treatment to control.
}
\details{
  The mitigated fraction is an estimator that quantifies an
  intervention's effect on reducing the severity of a
  condition. Since its units are on the probability scale,
  it is often a good idea to accompany it with an estimator
  on the original scale of measurement.
}
\examples{
MFr(lesion~group,calflung)
# [1] 0.44
}
\author{
  David Siev
}
\references{
  Siev D, 2005. An estimator of intervention effect on
  disease severity. \emph{Journal of Modern Applied
  Statistical Methods.} 4:500-508
}

