% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Releases.R
\name{generateReleaseVector}
\alias{generateReleaseVector}
\title{Make List of Modified Mosquito Releases}
\usage{
generateReleaseVector(driveCube, releasesParameters, nameGenotypes = NULL)
}
\arguments{
\item{driveCube}{Gene-drive cube}

\item{releasesParameters}{A list containing the releasesStart, releasesNumber
releasesInterval, and releaseProportion named values.}

\item{nameGenotypes}{Optional list to specify different genotypes for egg/male/female
releases. This is required for mated female releases. This parameter overrides
the default release type.}
}
\description{
Sets up a release schedule for a single patch, calls
\code{\link{basicRepeatedReleases}} internally.
}
\examples{
# setup a drive cube, using Mendelian as the example
cube <- cubeMendelian()

# setup release parameter list
#  releasesStart is the time of first release
#  releasesNumber is the number of releases
#  releasesInterval is the number of days between releases
#  releaseProportion is the number of mosquitoes released
relParams <- list(releasesStart = 25, releasesNumber = 1,
                  releasesInterval = 0, releaseProportion = 10)

# generate male releases
mRelVec <- generateReleaseVector(driveCube = cube,
                                 releasesParameters = relParams)

# generate mated female releases
fRelVec <- generateReleaseVector(driveCube = cube,
                                 releasesParameters = relParams,
                                 nameGenotypes = list(c("AA","AA", 10),
                                                      c("AA","aa", 10)))

}
