% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-lifecycle-network-T.R
\name{spn_T_lifecycle_network}
\alias{spn_T_lifecycle_network}
\title{Make Transitions (T) For a Network (Mosquitoes only)}
\usage{
spn_T_lifecycle_network(spn_P, params, cube, n = NULL, m_move = NULL)
}
\arguments{
\item{spn_P}{set of places produced by \code{\link{spn_P_lifecycle_network}}}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}

\item{n}{an integer giving the number of nodes}

\item{m_move}{binary adjacency matrix indicating if movement of mosquitoes between nodes is possible or not}
}
\value{
a list with two elements: \code{T} contains transitions packets as lists,
\code{v} is the character vector of transitions (T)
}
\description{
This function makes the set of transitions (T) for a SPN model of a
metapopulation network. It is the network version of \code{\link{spn_T_lifecycle_node}}.
}
\details{
This function takes the places produced from \code{\link{spn_P_lifecycle_network}}
and builds all possible transitions between subsets of those places.

The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, and \code{nP} parameters to be specified. For more details, see
\code{\link{equilibrium_lifeycle}}

While this function produces all structural information related to transitions,
hazards are produced by a separate function, \code{\link{spn_hazards}}.

For larger networks, this function may take some time to return, please be patient;
the Petri Net modeling formalism trades additional computation time at model
initialization for faster sampling of trajectories within a simulation.

Please note, the movement matrix (\code{m_move}) is NOT a
stochastic matrices, just a binary matrix that say if i,j can exchange population.
Diagonal elements must be \code{FALSE}.

At least one of the arguments \code{n} and \code{m_move} must be provided. If both are provided
\code{n} is ignored.

For examples of using this function, see:
\code{vignette("lifecycle-network", package = "MGDrivE2")}
}
