% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWERSS.R
\name{MBonf.p.adjust}
\alias{MBonf.p.adjust}
\title{The adjusted p-values for Modified Bonferroni single-step FWER controlling procedure.}
\usage{
MBonf.p.adjust(p, p.set)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \eqn{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values
}
\note{
The attainable p-value refers to the element of domain set of p-value for the corresponding hypothesis. For continuous test statistics, the p-value under true null are uniform distributed in (0,1), thus the p-values are attainable everywhere between 0 and 1. But for discrete test statistics, the p-value can only take finite values bewtween 0 and 1, that is the attainable p-values for discrete case are finite and countable, so we can assign them in a finite list \code{p.set}.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
MBonf.p.adjust(p,p.set)
}
\author{
Yalin Zhu
}

