% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResp.R
\name{plotResp}
\alias{plotResp}
\title{Plot single-effect model response.}
\usage{
plotResp(data, dvdata, EV, dir = NULL, logscale = FALSE, ...)
}
\arguments{
\item{data}{Data frame containing the response variable in the first column
and explanatory variables in subsequent columns. The response variable
should represent presence/background data, coded as: 1/NA. See
\code{\link{readData}}.}

\item{dvdata}{List of explanatory variables used to train the model, where
each list item is a data frame containing \emph{selected} DVs for a
\emph{selected} EV (e.g. the first item in the list returned by
\code{\link{selectEV}}).}

\item{EV}{Name or list index of the explanatory variable in \code{dvdata} for
which the response curve is to be generated. Interaction terms not allowed.}

\item{dir}{Directory to which files will be written. Defaults to the working
directory.}

\item{logscale}{Logical. Plot the common logarithm of PRO rather than PRO
itself.}

\item{...}{Arguments to be passed to \code{plot} to control the appearance of
the plot. For example: \itemize{ \item \code{cex} for size of points \item
\code{col} for color \item \code{pch} for type }}
}
\value{
In addition to the graphical output, the plotted data is returned. In
  the case of a continuous EV, the plotted data is a list of 2: \enumerate{
  \item \code{respPts}. Model response across individual data points. Columns
  in this data frame represent the following: EV value ("EV"), Probability
  Ratio Output of the model ("PRO"), and corresponding EV interval ("int").
  \item \code{respLine}. Model response across intervals of the EV. Columns
  in this data frame represent the following: EV interval ("int"), number of
  points in the interval ("n"), mean EV value of the points in the interval
  ("intEV"), mean Probability Ratio Output of the points in the interval
  ("intPRO"), and exponentially weighted moving average of intPRO
  ("smoothPRO").}

  In the case of a categorical EV, the plotted data is a data frame
  containing the number of points in the level ("n"), the level name
  ("level"), and the mean Probability Ratio Output of the level ("levelRV").
}
\description{
\code{plotResp} plots the single-effect response of a given Maxent model over
any of the included explanatory variables (EVs) in that model. For
categorical variables, a bar plot is returned rather than a scatter plot.
\code{plotResp} also returns a data frame containing the plotted data (for
customizable graphics). Single-effect response curves present the response of
a model containing the explanatory variable of interest only (cf.
marginal-effect response curves; \code{\link{plotResp2}}).
}
\details{
The plot contains points, representing the model response across individual
data points, as well as a line, representing an exponentially weighted moving
average of the model response over intervals of the EV.

The \code{EV} specified in \code{dvdata} must not be an interaction term.
}
\examples{
\dontrun{
responseEV1 <- plotResp(dat, deriveddat, "EV1", dir = "D:/path/to/modeling/directory")

# From vignette
pr_bygallResp <- plotResp(grasslandPO, grasslandEVselect[[1]], "pr_bygall")
par(mfrow = c(1,2))
pr_bygallFOP <- plotFOP(grasslandPO, "pr_bygall", intervals=50)
pr_bygallResp <- plotResp(grasslandPO, grasslandEVselect[[1]], "pr_bygall")
par(mfrow = c(1,1))
}

}

