% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate_signal}
\alias{interpolate_signal}
\title{Interpolate missing points and unify sampling rate for multi-channel signal}
\usage{
interpolate_signal(
  df,
  method = "spline_natural",
  sr = 100,
  st = NULL,
  et = NULL
)
}
\arguments{
\item{df}{dataframe. Input multi-channel accelerometer signal.}

\item{method}{string. Interpolation algorithms. Could be "spline_natural",
"spline_improved" or "spline_fmm": see \code{\link[stats]{splinefun}};
and "linear": see \code{\link[stats]{approxfun}}. Default is "spline_natural".}

\item{sr}{number. Sampling rate in Hz of the output signal. Default is 100.}

\item{st}{POSIXct date. The start time for interpolation. If it is
\code{NULL}, it will use the start time of the input signal. Default is
\code{NULL}.}

\item{et}{POSIXct date. The end time for interpolation. If it is \code{NULL},
it will use the end time of the input signal. Default is \code{NULL}.}
}
\value{
dataframe. Interpolated signal.
}
\description{
\code{interpolate_signal} applies different interpolation algorithms to the
input multi-channel signal to fill in the missing samples and harmonizes the
sampling rate.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that has been used in functions: \code{\link{extrapolate}}, and
  \code{\link{simulate_new_data}}.
}

\examples{
  # Use sample data
  df = sample_raw_accel_data

  # Plot input
  illustrate_signal(df, plot_maxed_out_line=FALSE)

  # Interpolate to 100 Hz
  sr = 100

  # Interpolate the entire sequence of data
  output = interpolate_signal(df, sr=sr)

  # Plot output
  illustrate_signal(output, plot_maxed_out_line=FALSE)

  # Interpolate part of the sequence
  output = interpolate_signal(df, sr=sr, st=df[10,1], et=df[100,1])

  # Plot output
  illustrate_signal(output, plot_maxed_out_line=FALSE)
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{cut_off_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{sampling_rate}()},
\code{\link{segment_data}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
