% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_data.R
\name{export_to_actilife}
\alias{export_to_actilife}
\title{Export accelerometer data in Actilife RAW CSV format}
\usage{
export_to_actilife(
  df,
  filepath,
  actilife_version = "6.13.3",
  firmware_version = "1.6.0"
)
}
\arguments{
\item{df}{dataframe. Input accelerometer data. The first column is timestamp
in POSXlct format, and the rest columns are accelerometer values in g
(\eqn{9.81m/s^2}).}

\item{filepath}{string. The output filepath.}

\item{actilife_version}{string. The Actilife version number to be added to
the header. Default is "6.13.3", that was used by the algorithm during
development.}

\item{firmware_version}{string. The firmware version number to be added to
the header. This is supposed to be the firmware version of the Actigraph
devices. We did not see any usage of the number during the computation of
Actigraph counts by Actilife, so it may be set with an arbitrary version
code seen in any Actigraph devices. We use default version code "1.6.0".}
}
\value{
No return value.
}
\description{
\code{export_to_actilife} exports the input dataframe as a csv file that is
compatible with Actilife.
}
\details{
This function takes an input accelerometer dataframe and exports it in
Actilife RAW CSV format with a prepended a madeup header. The exported file
csv file has compatible header, column names, timestamp format with Actilife
and can be imported directly into Actilife software.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is an utility
function that was used to convert validation data into Actilife RAW CSV
format so that we can use Actilife to compute Actigraph counts values for
these data.
}

\examples{
  # Use the first 5 rows from sample data
  df = sample_raw_accel_data[1:5,]
  head(df)

  # Save to current path with default mocked actilife and firmware versions
  filepath = tempfile()
  export_to_actilife(df, filepath)

  # The saved file will have the same format as Actigraph csv files
  readLines(filepath)

  # Cleanup
  file.remove(filepath)
}
\seealso{
Other File I/O functions: 
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
