% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_correction.R
\name{ols_bca}
\alias{ols_bca}
\title{Additive bias‐corrected OLS estimator}
\usage{
ols_bca(Y, Xhat, fpr, m, intercept = TRUE)
}
\arguments{
\item{Y}{Numeric vector of responses.}

\item{Xhat}{Numeric matrix of regressors excluding the intercept.
The first column \strong{must} be the ML-generated variable to correct.}

\item{fpr}{Numeric.  Estimated false-positive rate of the generated regressor.}

\item{m}{Integer.  Size of the validation (labeled) sample used to estimate \code{fpr}.}

\item{intercept}{Logical; if \code{TRUE}, an intercept column of 1’s is prepended.}
}
\value{
An object of class \code{mlbc_fit} and subclass \code{mlbc_bca}, a list with elements
\itemize{
\item \code{coef}: Numeric vector of bias-corrected coefficients (intercept first, if requested).
\item \code{vcov}: Variance–covariance matrix of those coefficients.
}
}
\description{
Computes the additive bias correction (BCA) for an OLS
regression when the primary regressor is measured by an ML/AI method.
}
\examples{
# unlabeled:
Nunl      <- 1e4
Xtrue_unl <- rbinom(Nunl, 1, 0.2)
Xhat_unl  <- ifelse(runif(Nunl) < 0.1, 1, Xtrue_unl)
Y_unl     <- 5 + 2 * Xtrue_unl + rnorm(Nunl)

# small labeled sample to get fpr:
nval      <- 100
Xtrue_val <- rbinom(nval, 1, 0.2)
Xhat_val  <- ifelse(runif(nval) < 0.1, 1, Xtrue_val)
Y_val     <- 5 + 2 * Xtrue_val + rnorm(nval)
fpr_hat   <- mean(Xhat_val == 1 & Xtrue_val == 0)

# now do additive correction, with intercept
fit_bca <- ols_bca(
  Y        = Y_unl,
  Xhat     = matrix(Xhat_unl, ncol = 1, dimnames = list(NULL, "Xhat")),
  fpr      = fpr_hat,
  m        = nval,
  intercept= TRUE
)
print(fit_bca)

}
\references{
Battaglia, Christensen, Hansen, and Sacher (2025). "Inference for Regression with Variables Generated by AI or Machine Learning".
}
\seealso{
\link{ols_bcm} for the multiplicative correction.
}
