% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_correction.R
\name{ols_bcm}
\alias{ols_bcm}
\title{Multiplicative bias-corrected OLS estimator}
\usage{
ols_bcm(Y, Xhat, fpr, m, intercept = TRUE)
}
\arguments{
\item{Y}{Numeric vector (or one-column matrix) of responses.}

\item{Xhat}{Numeric matrix of regressors; \strong{the first column} must be
the ML-generated regressor whose bias we’re correcting, and remaining
columns are any additional “true” controls.}

\item{fpr}{Numeric scalar.  Estimated false-positive rate of the
generated regressor (proportion of ML positives that are actually negatives).}

\item{m}{Integer.  Size of the \strong{validation/labeled} subsample used to
estimate \code{fpr} — i.e.\ the number of observations where you observe both
the ML prediction (\code{Xhat}) and the true regressor.}

\item{intercept}{logical, \code{TRUE} by default.}
}
\value{
An object of class \code{mlbc_fit} (and subclass \code{mlbc_bcm}) with two components:
\itemize{
\item \code{coef}: Numeric vector of bias-corrected regression coefficients.
\item \code{vcov}: Variance-covariance matrix for those coefficients.
}
}
\description{
Computes the multiplicative bias correction (BCM) for an OLS
regression when the primary regressor is measured by an ML/AI method.
}
\examples{
# generate data
Nunl     <- 10000
Xtrue_unl<- rbinom(Nunl, 1, 0.2)
Xhat_unl <- ifelse(runif(Nunl) < 0.1, 1, Xtrue_unl)
Y_unl     <- 5 + 2*Xtrue_unl + rnorm(Nunl)
#estimate the false-positive rate
nval     <- 100
Xtrue_val<- rbinom(nval, 1, 0.2)
Xhat_val <- ifelse(runif(nval) < 0.1, 1, Xtrue_val)
Y_val     <- 5 + 2*Xtrue_val + rnorm(nval)
fpr_hat  <- mean(Xhat_val==1 & Xtrue_val==0)
fit_bcm <- ols_bcm(Y_unl,
                  Xhat = matrix(Xhat_unl, ncol=1),
                  fpr = fpr_hat,
                  m   = nval,
                  intercept = TRUE)
summary(fit_bcm)
}
\references{
Battaglia, Christensen, Hansen, and Sacher (2025). "Inference for Regression with Variables Generated by AI or Machine Learning".
}
\seealso{
\link{ols_bca} for the additive correction.
}
