\name{binom.diagnostics}
\alias{binom.diagnostics}
\alias{plot.mlcm.diag}

\title{ Diagnostics for Binary GLM}
\description{Two techniques for evaluating the adequacy of the binary glm model used in \code{mlcm}, based on code in Wood (2006).
  }
\usage{
binom.diagnostics(obj, nsim = 200, type = "deviance")

\method{plot}{mlcm.diag}(x, alpha = 0.025, breaks = "Sturges", ...)
}
\arguments{
  \item{obj}{list of class \sQuote{mlcm} typically generated by a call to the \code{mlcm} }
  \item{nsim}{ integer giving the number of sets of data to simulate }
  \item{type}{character indicating type of residuals.  Default is deviance residuals.  See \code{\link{residuals.glm}} for other choices }
  \item{x}{list of class \sQuote{mlcm.diag} typically generated by a call to \code{binom.diagnostics}}
  \item{alpha}{numeric between 0 and 1, the envelope limits for the cdf of the deviance residuals}
  \item{breaks}{character or numeric indicating either the method for calculating the number of breaks or the suggested number of breaks to employ.  See \code{\link{hist}} for more details.}
  \item{...}{additional parameters specifications for the empirical cdf plot}
}
\details{
 Wood (2006) describes two diagnostics of the adequacy of a binary glm model based on analyses of residuals (see, p. 115, Exercise 2 and his solution on pp 346-347).  The first one compares the empirical cdf of the deviance residuals to a bootstrapped confidence envelope of the curve.  The second examines the number of runs in the sorted residuals with those expected on the basis of independence in the residuals, again using a resampling based on the models fitted values. The plot method generates two graphs, the first being the empirical cdf and the envelope.  The second is a histogram of the number of runs from the bootstrap procedure with the observed number indicated by a vertical line.  Currently, this only works if the \sQuote{glm} method is used to perform the fit and \emph{not} the \sQuote{optim} method
 }
\value{
 \code{binom.diagnostics} returns a list of class \sQuote{mlcm.diag} with components
  \item{NumRuns }{integer vector giving the number of runs obtained for each simulation}
  \item{resid }{numeric matrix giving the sorted deviance residuals in each column from each simulation}
  \item{Obs.resid }{numeric vector of the sorted observed deviance residuals}
  \item{ObsRuns }{integer giving the observed number of runs in the sorted deviance residuals}
  \item{p }{numeric giving the proportion of runs in the simulation less than the observed value.}
  }
\references{Wood, SN \emph{Generalized Additive Models: An Introduction with R}, Chapman \& Hall/CRC, 2006 

 Ho, Y. H., Landy. M. S.  and Maloney, L. T. (2008). Conjoint measurement of gloss and surface texture. \emph{Psychological Science}, \bold{19}, 196--204.
}
\author{ Ken Knoblauch }

\seealso{\code{\link{mlcm}} }
\examples{
\dontrun{
data(BumpyGlossy)
bg.mlcm <- mlcm(BumpyGlossy)
bg.diag <- binom.diagnostics(bg.mlcm)
plot(bg.diag)
}
}

\keyword{models}
\keyword{hplot}
