% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEce.R
\name{benchMLEce}
\alias{benchMLEce}
\title{Performing closed-form estimators against other methods}
\usage{
benchMLEce(data, distname, methods)
}
\arguments{
\item{data}{a numeric matrix.}

\item{distname}{a character indicating which distribution to be fitted. \code{BiGam} stands for the bivariate gamma distribution, \code{BiWei} stands for the bivariate Weibull distribution, and \code{Dirichlet} stands for the Dirichlet distribution.}

\item{methods}{a vector of methods: two characters among \code{"MLEce"} (efficient closed-form estimator), \code{"MLE"}, \code{"MME"} and \code{"CME"}. \code{MLEce} stands for efficient closed-form estimators, , \code{"MLE"} (maximum likelihood estimator), \code{"MME"} (method of moments estimator) and \code{"CME"} (correlation based method  estimator for the bivariate Weibull distribution).}
}
\value{
A matrix with estimate and time in seconds per method for assigned distributions.
}
\description{
Performing closed-form estimators against other methods
}
\examples{
#bivariate gamma distribution
data_BiGam= rBiGam(100, c(1,4,5))
benchMLEce(data_BiGam, distname="BiGam", methods=c("MLEce","MME"))
#bivariate Weibull distribution
data_BiWei <- rBiWei(n=50, c(4,3,3,4,0.6))
benchMLEce(data_BiWei, distname="BiWei", methods=c("MLE","CME"))
#multivariate Dirichlet distribution
data_Diri <- LaplacesDemon::rdirichlet(80, c(3,4,1,3,4))
benchMLEce(data_Diri, distname="Dirichlet", methods=c("MLEce","MLE"))
}
