% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{effect}
\alias{effect}
\title{Consider the effect of particular places upon the ID}
\usage{
effect(object, places)
}
\arguments{
\item{object}{an object of class \code{index}: a multilevel index created
using function \code{\link{id}}}

\item{places}{a character vector containing the names of the places in any of
the higher-level geographies for which the evaluation will be made}
}
\value{
an object, primarily a list containing the evaluated values
}
\description{
Evaluates the effect on the index of the named \code{places} under three
different scenarios.
}
\details{
The three different scenarios considered are:
\enumerate{
  \item if the effects (the estimated residuals from the multilevel
  model) are set to zero for the named higher-level \code{places};
  \item if the shares of the two population groups are equal everywhere
  except within the named \code{places}; and
  \item if all but the neighbourhoods within the named \code{places}
  are omitted from the data and the index then recalculated
  using only those that remain.
}
The evaluation also includes:
\itemize{
   \item the impact of the chosen places upon the overall ID, where a value
   over 100 indicates a group of neighbourhoods with a disproportionately
   high (in the same way that \code{\link{impacts}} calculates it)
   \item an R-squared value. This is the proportion of the total variation in
   (Y - X) that is due to the chosen places, where (Y - X) are the
   differences between the share of population group Y and the share of
   population group X that are observed in each neighbourhood.
}
See \code{vignette("MLID")} for further details
}
\examples{
\dontrun{
data(aggdata)
index <- id(aggdata, vars = c("Bangladeshi", "WhiteBrit"),
levels = c("MSOA","LAD","RGN"))
ci <- confint(index)
catplot(ci)
# Note Tower Hamlets and Newham. Obtain the predictions for them:
effect(index, "Tower Hamlets")
effect(index, "Newham")
effect(index, c("Tower Hamlets","Newham"))
}
}
\seealso{
\code{\link{id}}

Harris R (2017) Fitting a multilevel index of segregation in R:
using the MLID package \url{http://rpubs.com/profrichharris/MLID}
}
