% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process.R
\name{bin_length}
\alias{bin_length}
\title{Bin length data}
\usage{
bin_length(df, breaks = NULL)
}
\arguments{
\item{df}{A data frame or matrix of length observations. The first column should be named 
'Year' and the second column should be named 'Length'.}

\item{breaks}{An optional vector for breaks for \code{\link[graphics]{hist}}.}
}
\value{
A list with length bins, years, and frequency matrix.
}
\description{
A tool to bin raw length observations into a length frequency matrix.
}
\details{
Length frequencies from \code{Len_df} are created by using \code{\link[graphics]{hist}} function.
}
\examples{
data(SilkSnapper)
Silk.matrix <- bin_length(SilkSnapper, breaks = seq(80, 830, 10))
Silk.matrix <- bin_length(SilkSnapper)
new.dataset <- new("MLZ_data", Year = Silk.matrix$Year, Len_bins = Silk.matrix$Len_bins,
Len_matrix = Silk.matrix$Len_matrix)
 
}
