% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_confusion_matrix}
\alias{plot_confusion_matrix}
\title{Plotting Confusion Matrix}
\usage{
plot_confusion_matrix(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_confusion_matrix()} function generates confusion matrices for both training and test data
in classification problems. This visualization allows evaluation of classification accuracy by category
and identification of confusion patterns between classes, providing insights into which classes are most
frequently misclassified.
}
\examples{
# Note: For obtaining confusion matrix plot the user needs to
# complete till fine_tuning( ) function of the MLwrap pipeline and
# only with categorical outcome.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well_bin ~ depression + emot_intel + resilience,
                             task = "classification")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

# And then, you can obtain the confusion matrix plot.

plot_confusion_matrix(wrap_object)

}

}
