% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_yeardates.R
\name{get_yeardates}
\alias{get_yeardates}
\title{identify dates to be processed for a year}
\usage{
get_yeardates(download_range, yy, start_year, end_year, start_date, end_date)
}
\arguments{
\item{download_range}{\code{character ["Full" | "Seasonal"]} If "full", all the
available images between the starting and the ending dates are downloaded;
If "seasonal", only the images included in the season are downloaded
(e.g: if the starting date is 2005-12-01 and the ending is 2010-02-31, only
the images of December, January and February from 2005 to 2010 - excluding
2005-01, 2005-02 and 2010-12 - are downloaded), Default: Full}

\item{yy}{\code{numeric} year for which the processing dates need to be identified}

\item{start_year}{\code{numeric} start year of current \code{MODIStsp_process} run}

\item{end_year}{\code{numeric} end year of current \code{MODIStsp_process} run.}

\item{start_date}{\verb{character`` Start date for images download and preprocessing (yyyy.mm.dd) of current }MODIStsp_process` run.}

\item{end_date}{\code{character} Start date for images download and preprocessing
(yyyy.mm.dd) of current \code{MODIStsp_process} run.}
}
\value{
OUTPUT_DESCRIPTION
}
\description{
helper function needed to identify the ranges of dates to
be processed for a given year as a function of \code{download_range} selection
and starting/ending dates and years
}
\author{
Lorenzo Busetto, phD (2017) \href{mailto:lbusett@gmail.com}{lbusett@gmail.com}
}
