% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signalPreprocess.R
\name{SignalNormalization}
\alias{SignalNormalization}
\title{Normalization process}
\usage{
SignalNormalization(
  dataFolder,
  chipType,
  normalTumorArray,
  genotypeCallsMethod = "naive",
  savePlot = TRUE,
  tags = NULL
)
}
\arguments{
\item{dataFolder}{Name of the data set.}

\item{chipType}{Type of the chip used for the data.}

\item{normalTumorArray}{Only in the case of normal-tumor study. A csv file or a data.frame containing the mapping between normal and tumor files.
The first column contains the name of normal files and the second the names of associated tumor files.}

\item{genotypeCallsMethod}{method used for genotypage, default is "naive".}

\item{savePlot}{If TRUE, graphics of the CN signal and allele B fraction signal will be saved in the figures folder.}

\item{tags}{Common tag which appears in the different file names (cdf, ugp, ufl) of the chip. For no tag, use tags=NULL (default = NULL). See details for more information.}
}
\value{
No return value, called for side effects.
}
\description{
low-level normalization process for estimating raw copy-numbers and allele B fraction.
}
\details{
The aroma architecture must be respected:
   <working directory>
    +- annotationData/
    |  +- chipTypes/
    |     +- <chipType>/ <-- must match exactly the name of the CDF file (fullname minus tags)
    |        +- CDF file(s) and other annotation (possibly subdirectories)
    |
    +- rawData/
       +- <nameOfDataSet>/
          +- <chipType>/ <-- must match exactly a chip type folder under annotationData/
             +- CEL files


All the cdf chip file names must follow the following rule : <chipType>,<Tags>.cdf

Multiples tags must be separated by  a comma. If there is no tag, the pattern is <chipType>.cdf
}
\author{
Quentin Grimonprez
}
