
.get.mpt.model <- function (model.filename, model.type, model.check = TRUE){
	
	if ("connection" %in% class(model.filename)) model <- .read.MPT.model(model.filename)
	else {
	if (model.type[1] == "easy" & (grepl("\\.eqn$", model.filename) || grepl("\\.EQN$", model.filename))) model.type <- "eqn"
	model <- switch(model.type[1],
		easy = .read.MPT.model(model.filename),
		eqn = .read.EQN.model(model.filename),
		eqn2 = .read.EQN.model.2(model.filename)
	)
	}
	prob.tree.check <- .check.MPT.probabilities(model)
	if (model.check) if(isTRUE(!(all(prob.tree.check==1)))) stop(paste("Model not constructed well: Branch probabilities of tree(s) ", paste(which(prob.tree.check!=1), collapse= ", "), " do not sum to 1!", sep = ""))
	return (model)
}
