% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{srug}
\alias{srug}
\title{srug is the Schnute and Richards Unified Growth Curve}
\usage{
srug(p, sizeage)
}
\arguments{
\item{p}{a vector of four parameters begin Schnute and Richards' 
a, b, c, and alpha, in that order.}

\item{sizeage}{the age or size data used to describe the maturity
transition.}
}
\value{
A vector of predicted proportion mature (proportion of 1.0) 
    for the given parameters and the sizeage data
}
\description{
srug implements the Schnute and Richards (1990) unified 
    growth curve that can be used to describe fish growth, 
    maturation, and survivorship data. It is a curve 
    that generalizes the classical logistic model used for maturity 
    as well the growth models by Gompertz (1825), von Bertalanffy 
    (1938), Richards (1959), Chapman (1961), and Schnute (1981). As
    with any asymmetric, multi-parameter model, it can be hard to 
    obtain a stable fit of this curve to data. Here the model is
    implemented to range between 0 - 1, if you want to use it to 
    describe growth then re-cast the function and add a fifth
    parameter to replace the 1.0 on top of the divisor. The main point of the
    curve, however, was to demonstrate how the different equations were 
    related to one another. In working situations it is most efficient 
    to use the original, simpler, curve/equation.
}
\examples{
 L <- seq(50,160,1)
 p <- c(a=0.07,b=0.2,c=1.0,alpha=100.0)
 predR <- srug(p=p,sizeage=L) # proportion of total
 oldpar <- par(no.readonly=TRUE)
 plot1(L,predR,xlab="Length",ylab="Prop of Recruitment")
 abline(h=0.5) #visually confirm asymmetry
 par(oldpar)
}
\references{
Schnute, J.T. and L.J. Richards (1990) A unified approach 
    to the analysis of fish growth, maturity, and survivorship data. 
    \emph{Canadian Journal of Fisheries and Aquatic Science} 47:24-40
}
