% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{tigers}
\alias{tigers}
\title{tigers is tiger prawn recruitment data from Penn & Caputi 1986}
\format{
A data.frame of spawning recruitment data
\describe{
  \item{Spawn}{the estimated spawning biomass index in a year (Aug - Oct)}
  \item{Recruit}{estimated recruitment from the biomass in each year (Mar - May)}
}
}
\source{
Extracted from Table 2, page 496 of Penn, J.W. and N. Caputi 
    (1986) Spawning stock-recruitment relationships and environmental 
    influences on the tiger prawn (\emph{Penaeus esculentus}) fishery 
    in Exmouth Gulf, Western Australia. \emph{Australian Journal of 
    Marine and Freshwater Research} 37: 491-505. Sorted on spawning index.
}
\description{
tigers is a dataset of only 14 rows of data with a 
    column of Spawning index and Recruitment index, as a data.frame. 
    The timing of the recruitment index is up to half a year after 
    the spawning index.
}
\section{Subjects}{

 \itemize{
   \item Stock-recruitment curves
   \item Beverton-Holt and Ricker Models
   \item Static model fitting
 }
}

\examples{
 data(tigers)
 tigers
 oldpar <- par(no.readonly=TRUE)
 plot1(tigers$Spawn,tigers$Recruit,type="p",pch=16,cex=1.25)
 par(oldpar)
}
