\name{plotSigmaGR}
\title{Display quality criteria for the GR algorithm}
\alias{plotSigmaGR}
\description{
Display the quality criteria for various values of sigma using the result of the \code{calcSigmaGR} function.
}
\usage{
plotSigmaGR(calcSigmaGR, mar = c(3, 3, 2, 2), mgp = c(2, 0.75, 0), main = "",
     col = c("black", grDevices::rainbow(5)),
     criterion = c("n.obs", "transition", "sdfront", "entropy", "Kalinsky", "Laboure"),
     name_criteria = c("region size", "boundary transition", "boundary heterogeneity", 
                       "region entropy", "region Kalinsky", "region Laboure"), 
     filename = "calcSigmaGR", ...)
}
\arguments{
  \item{calcSigmaGR}{an object generated by the \code{\link{calcSigmaGR}} function. REQUIRED.} 
  \item{mar}{the number of margin lines to be specified on the four sides of the plot. \emph{positive numeric vector of size 4}.}
  \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.}
  \item{main}{an overall title for the plot. \emph{character}.}
  \item{col}{the color to use to plot each criterion. \emph{character vector}.}
  \item{criterion}{the criterion to be displayed. \emph{character vector}.}
  \item{name_criteria}{the name to be used in the legend. \emph{character vector}.}
  \item{filename}{the name of the file used to export the plot. \emph{character}.}
  \item{...}{additional arguments for the graphical device : \code{window}, \code{width}, \code{height}, \code{path}, \code{unit}, \code{res} (see \code{\link{optionsMRIaggr}}).}
  }
\seealso{ 
 \code{\link{calcSigmaGR}} to compute the quality criteria.
}
\examples{
## load an \code{MRIaggr} object
data(MRIaggr.Pat1_red, package = "MRIaggr")

calcThresholdMRIaggr(MRIaggr.Pat1_red,param = c("TTP_t0","MTT_t0"), threshold = 1:10,
                     name_newparam = c("TTP.th_t0","MTT.th_t0"),
                     update.object = TRUE, overwrite = TRUE)

## display raw parameter
multiplot(MRIaggr.Pat1_red, param = "TTP.th_t0", num = 3, numeric2logical = TRUE,
          index1 = list(coords = "MASK_DWI_t0", outline = TRUE))

## extract raw parameter, coordinates and compute the neighbourhood matrix
carto <- selectContrast(MRIaggr.Pat1_red, num = 3, hemisphere = "lesion",
                        param = c("TTP.th_t0","TTP_t0","MASK_DWI_t0"))
coords <- selectCoords(MRIaggr.Pat1_red, num = 3, hemisphere = "lesion")
W <- calcW(coords, range = sqrt(2))$W

## the seed is taken to be the point with the largest TTP in the lesion mask
indexN <- which(carto$MASK_DWI_t0 == 1)
seed <- indexN[which.max(carto[indexN,"TTP_t0"])]

## find optimal sigma
resGR_sigma <- calcSigmaGR(contrast = carto$TTP.th_t0, W = W, seed = seed,
                           sigma = seq(1,4,0.1), iter_max = 50,
                           keep.upper = TRUE)

## display quality criteria according to sigma
plotSigmaGR(resGR_sigma)

plotSigmaGR(resGR_sigma, criterion = "entropy")
}
\concept{plot.}
\keyword{functions}
