% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrt_binary_power.R
\name{mrt_binary_power}
\alias{mrt_binary_power}
\title{Calculate power for binary outcome MRT}
\usage{
mrt_binary_power(avail_pattern, f_t, g_t, beta, alpha, p_t, gamma, n)
}
\arguments{
\item{avail_pattern}{A vector of length m that is the average availability at
each time point}

\item{f_t}{Defines marginal excursion effect MEE(t) under
alternative together with beta. Assumed to be matrix of size m*p.}

\item{g_t}{Defines success probability null curve together with
alpha. Assumed to be matrix of size m*q.}

\item{beta}{Length p vector that defines marginal excursion effect
MEE(t) under alternative together with f_t.}

\item{alpha}{Length q vector that defines success probability null
curve together with g_t.}

\item{p_t}{Length m vector of Randomization probabilities at each
time point.}

\item{gamma}{Desired Type I error}

\item{n}{Sample size}
}
\value{
Power of the test for fixed null/alternative and sample
  size.
}
\description{
Returns power of the hypothesis test of marginal excursion effect (see Details) given 
a specified sample size in the context of an MRT with binary outcomes
with small sample correction using F-distribution. See the vignette for
more details.
}
\examples{
           mrt_binary_power(tau_t_1, f_t_1, g_t_1, beta_1,
                                              alpha_1, p_t_1, 0.05, 100)
}
