% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PCGMM-class}
\alias{PCGMM-class}
\title{PCGMM Class}
\description{
An object containing the estimates produced using the univariable principal components generalized method of methods (PC-GMM) method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{robust}}{Whether the robust model with overdispersion heterogeneity is estimated.}

\item{\code{Exposure}}{The name of the exposure variable.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Correlation}}{The matrix of correlations between genetic variants.}

\item{\code{Estimate}}{The causal estimate from the PC-GMM method.}

\item{\code{StdError}}{The standard error associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Fstat}}{The first-stage F statistic for all genetic principal components used as instruments.}

\item{\code{Overdispersion}}{The estimate of the overdispersion parameter for the robust model.}

\item{\code{PCs}}{The number of genetic principal components used to instrument the exposure.}

\item{\code{Pvalue}}{P-value associated with the causal estimate.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Heter.Stat}}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value (for non-robust model): the null hypothesis is that all principal components estimate the same causal parameter; rejection of the null is an indication that one or more principal components may be pleiotropic.}
}}

