% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_lr.R
\name{multi_lr}
\alias{multi_lr}
\title{(Weighted) Log-rank test for comparison of two or more survival curves.}
\usage{
multi_lr(df, weights, test = c("lr", "gw", "fh"), rho = 1, gamma = 0)
}
\arguments{
\item{df}{A data frame with columns :
\itemize{
\item \code{time} : positive numbers, time-to-event;
\item \code{status} : vector of integer, 0 or 1. 0 is (right) censoring, 1 is event;
\item \code{arm} : a factor or object that can be coerced to one. The group the patient
belongs to. Must have at least two levels.
}}

\item{weights}{An object that can be coerced to a matrix. The weights
used for the tests. Can be omitted (see Details);}

\item{test}{If \code{weights} is omitted, specify the test to perform. Possible values are
\code{lr} for log-rank, \code{gw} for Gehan-Wilcoxon, and \code{fh} for Flemming-Harrington;}

\item{rho, gamma}{The parameters for Flemming-Harrington test. Default is (rho,gamma)=(1,0),
which is also called the Peto-Peto test.}
}
\value{
An object of class \code{multi_lr} containing:
\itemize{
\item \code{U} : Statistics of tests;
\item \code{p} : The corresponding p-values;
\item \code{degree} : Degrees of freedom of the statistics of tests;
\item The argument \code{test}, changed to "chosen" if weights are given.
}
}
\description{
Performs a global log-rank test for comparing two or more survival curves.
}
\details{
\code{weights} contains the chosen weights for the test. It must be a vector, a matrix
or an object that can be coerced to a matrix, like a data frame (passed as
argument to \code{as.matrix}). Can be omitted.

If not given (default), then perform either a log-rank test, a Gehan-Wilcoxon
test or a Fleming-Harrington test depending on the choice of \code{test}.

If \code{weights} is a one-dimension vector, its length must be equal to the
number of distinct time of event and throws an error if it is not true. In this
case, \code{multi_lr()} performs a weighted log-rank test with the specified weights.

If \code{weights} is a matrix (or a two-dimension object), its number of rows
must be equal to the number of distinct time of event and throws an error if
it is not true. In this case, \code{multi_lr()} performs as many tests as the
number of columns in \code{weights}. The first test is a weighted log-rank test
with weights the first column of \code{weights}, the second test is a weighted
log-rank test with weights the second column of \code{weights}, and so on.
}
\examples{
  # Log-rank test
  multi_lr(data_not_PH)

  # Gehan-Wilcoxon test
  multi_lr(data_not_PH, test="gw")

  # It is possible to run several tests with different weights at a time
  evt_time = unique(data_not_PH$time[data_not_PH$status == 1])
  nb_evt_time = length(evt_time)
  weights = matrix(runif(nb_evt_time*3), ncol=3)
  multi_lr(data_not_PH, weights=weights)
}
