% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPA2OM.R
\name{VPA2OM}
\alias{VPA2OM}
\title{Reads bootstrap estimates from a VPA stock assessment into an operating model.}
\usage{
VPA2OM(
  Name = "A fishery made by VPA2OM",
  proyears = 50,
  interval = 2,
  CurrentYr = 2019,
  h = 0.999,
  Obs = MSEtool::Imprecise_Unbiased,
  Imp = MSEtool::Perfect_Imp,
  naa,
  faa,
  waa,
  Mataa,
  Maa,
  laa,
  nyr_par_mu = 3,
  LowerTri = 1,
  recind = 2,
  plusgroup = TRUE,
  altinit = 0,
  fixq1 = TRUE,
  report = FALSE,
  silent = FALSE
)
}
\arguments{
\item{Name}{Character string. The name of the operating model.}

\item{proyears}{Positive integer. The number of projection years for MSE.}

\item{interval}{Positive integer. The interval at which management procedures will update the management advice in \link[MSEtool]{runMSE}, e.g., 1 = annual updates.}

\item{CurrentYr}{Positive integer. The current year (final year of VPA fitting to data)}

\item{h}{Numeric value greater than 0.2 and less than 1. The steepness of the stock-recruitment curve (assumed to be close to 1 to match VPA assumption).}

\item{Obs}{The observation model (class Obs). This function only updates the catch and index observation error.}

\item{Imp}{The implementation model (class Imp). This function does not update implementation parameters.}

\item{naa}{Numeric array \verb{[sim, ages, year]}. Numbers-at-age \verb{[first age is age zero]}.}

\item{faa}{Numeric array \verb{[sim, ages, year]}. Fishing mortality rate-at-age \verb{[first age is age zero]}.}

\item{waa}{Numeric array \verb{[sim, ages, year]}. Weight-at-age \verb{[first age is age zero]}.}

\item{Mataa}{Numeric array \verb{[sim, ages, year]}. Maturity (spawning fraction)-at-age \verb{[first age is age zero]}.}

\item{Maa}{Numeric array \verb{[sim, ages, year]}. Natural mortality rate-at-age \verb{[first age is age zero]}.}

\item{laa}{Numeric array \verb{[sim, ages, year]}. Length-at-age \verb{[first age is age zero]}.}

\item{nyr_par_mu}{Positive integer. The number of recent years that natural mortality, age vulnerability, weight, length and maturity parameters are averaged over for defining future projection conditions.}

\item{LowerTri}{Integer. The number of recent years for which model estimates of recruitment are ignored (not reliably estimated by the VPA)}

\item{recind}{Positive integer. The first age class that fish 'recruit to the fishery'. The default is 2 - ie the first position in the age dimension of naa is age zero}

\item{plusgroup}{Logical. Does the VPA assume that the oldes age class is a plusgroup?}

\item{altinit}{Integer. Various assumptions for how VPAs set up the initial numbers. 0: standard, 1: no plus group, 2: temporary fix for MSEtool plus group initialization}

\item{fixq1}{Logical. Should q be fixed (ie assume the F-at-age array faa is accurate?}

\item{report}{Logical, if TRUE, a diagnostic will be reported showing the matching of the OM reconstructed numbers at age vs the VPA assessment.}

\item{silent}{Whether to silence messages to the console.}
}
\value{
An object of class \linkS4class{OM}.
}
\description{
A function that uses a set of VPA bootstrap estimates of numbers-at-age, fishing mortality rate-at-age, M-at-age,
weight-at-age, length-at-age and Maturity-at-age to define a fully described MSEtool operating model. The user still
needs to parameterize most of the observation and implementation portions of the operating model.
}
\seealso{
\link{SS2OM}
}
\author{
T. Carruthers
}
