% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2MOM.R, R/SS2OM.R
\name{SS2MOM}
\alias{SS2MOM}
\alias{SS2OM}
\alias{SSMOM2OM}
\alias{plot_SS2OM}
\title{Import Stock Synthesis to MOM (2-sex multi-fleet) or OM (single-sex, single-fleet)}
\usage{
SS2MOM(
  SSdir,
  nsim = 48,
  proyears = 50,
  reps = 1,
  maxF = 3,
  seed = 1,
  interval = 1,
  pstar = 0.5,
  Obs = MSEtool::Generic_Obs,
  Imp = MSEtool::Perfect_Imp,
  silent = FALSE,
  Name = "MOM generated by SS2MOM",
  Source = "No Source provided",
  ...
)

SS2OM(
  SSdir,
  nsim = 48,
  proyears = 50,
  reps = 1,
  maxF = 3,
  seed = 1,
  interval = 1,
  pstar = 0.5,
  Obs = MSEtool::Generic_Obs,
  Imp = MSEtool::Perfect_Imp,
  import_mov = TRUE,
  gender = 1:2,
  seasons_to_years = TRUE,
  model_discards = TRUE,
  silent = FALSE,
  Name = "OM generated by SS2OM function",
  Source = "No source provided",
  Author = "No author provided",
  report = FALSE,
  filename = "SS2OM",
  dir = tempdir(),
  open_file = TRUE,
  ...
)

SSMOM2OM(
  MOM,
  SSdir,
  gender = 1:2,
  import_mov = TRUE,
  seed = 1,
  silent = FALSE,
  model_discards = TRUE
)

plot_SS2OM(
  x,
  SSdir,
  gender = 1:2,
  filename = "SS2OM",
  dir = tempdir(),
  open_file = TRUE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it.}

\item{nsim}{The number of simulations to take for parameters with uncertainty (for OM@cpars custom parameters).}

\item{proyears}{The number of projection years for MSE}

\item{reps}{The number of stochastic replicates within each simulation in the operating model.}

\item{maxF}{The maximum allowable F in the operating model.}

\item{seed}{The random seed for the operating model.}

\item{interval}{The interval at which management procedures will update the management advice in \link{multiMSE}, e.g., 1 = annual updates.}

\item{pstar}{The percentile of the sample of the management recommendation for the MP/MMP.}

\item{Obs}{The observation model (class Obs). These functions do not update implementation parameters.}

\item{Imp}{The implementation model (class Imp). These functions do not update implementation parameters.}

\item{silent}{Whether to silence messages to the console.}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}.}

\item{import_mov}{Logical. Import movement matrix?}

\item{gender}{An integer that indexes the sex for importing life history parameters (1 = usually female, 2 = usually male, 1:2 = mean across both sexes).
Only used for \code{SS2OM} only in a 2-sex model.}

\item{seasons_to_years}{Logical, when season is the time step, whether to convert OM from a seasonal model to annual model.}

\item{model_discards}{Logical, how to simplify a multi-fleet SS model to an OM object. If TRUE, OM will still model discards using
the mean retention across fleets (weighted by fleet F). Otherwise, no discards are modeled and all fishing removals are calculated in the OM
from the SS F-at-age matrix.}

\item{Author}{Who did the assessment}

\item{report}{Logical, if TRUE, the function will run \link{runMSE} to generate the Hist object from the operating model
to compare against SS output. A markdown report will be generated.}

\item{filename}{If \code{report = TRUE}, character string for the name of the markdown and HTML files.}

\item{dir}{If \code{report = TRUE}, the directory in which the markdown and HTML files will be saved.}

\item{open_file}{If \code{report = TRUE}, whether the HTML document is opened after it is rendered.}

\item{MOM}{MOM object}

\item{x}{For \code{plot_SS2OM}, an object of either class \linkS4class{OM} or \linkS4class{Hist}.}
}
\value{
SS2MOM returns an object of class \linkS4class{MOM}. SS2OM returns an object of class \linkS4class{OM}.
}
\description{
Functions that uses the file location or the r4ss output list of a fitted SS3 model including input files to populate the
various slots of an \linkS4class{MOM} or \linkS4class{OM} object. \code{SS2MOM} and \code{SS2OM} mainly populates the Stock and Fleet components
components of the operating model. \code{SS2MOM} creates a 2-sex model and multiple fleets with discarding behavior.
\code{SS2OM} returns a single sex (either male, female, or averaged biological parameters) and single fleet (aggregate selectivity and mortality,
no explicit discarding modeled). For either, the user still needs to parameterize most of the observation and
implementation portions. \code{SSMOM2OM} is the internal function that simplifies the MOM object to an OM object.
\code{plot_SS2OM} generates a markdown report to compare the OM and SS output.
}
\note{
Currently tested on r4ss version 1.38.1-40.0 and SS 3.30.14.
}
\seealso{
\link{SS2Data} \link{SS2DataMOM}
}
\author{
Q. Huynh
}
