% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.R
\name{BIC}
\alias{BIC}
\alias{BIC.MSGARCH_ML_FIT}
\alias{BIC.MSGARCH_MCMC_FIT}
\title{Bayesian information criterion (BIC).}
\usage{
BIC(fit)

\method{BIC}{MSGARCH_ML_FIT}(fit)

\method{BIC}{MSGARCH_MCMC_FIT}(fit)
}
\arguments{
\item{fit}{Fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}}
or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}}
}
\value{
BIC value.
}
\description{
Method which computes the Bayesian information criterion (BIC) from a fit object of type
\code{MSGARCH_ML_FIT} created with \code{\link{FitML}}
or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.
}
\details{
Computes the Bayesian information criterion (BIC) based on the work of Schwarz (Schwarz, 1978).
If a matrix of MCMC posterior draws is given, the BIC on the posterior mean is calculated.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on data by ML
fit <- FitML(spec = spec, data = SMI)

# compute BIC
BIC(fit)
}
\references{
Schwarz, G. (1978).
Estimating the dimension of a model.
\emph{Annals of Statistics}, 6, 461-464.
}
