% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{argrid_MSARmdl}
\alias{argrid_MSARmdl}
\title{Autoregressive moment grid}
\usage{
argrid_MSARmdl(mu, sig, k, ar, msmu, msvar)
}
\arguments{
\item{mu}{vector (\code{k x 1}) of mu in each regime.}

\item{sig}{vector (\code{k x 1}) of sigma in each regime.}

\item{k}{integer determining the number of regimes.}

\item{ar}{number of autoregressive lags.}

\item{msmu}{Boolean indicator. If \code{TRUE} mean is subject to change. If \code{FALSE} mean is constant across regimes.}

\item{msvar}{Boolean indicator. If \code{TRUE} variance is subject to change. If \code{FALSE} variance is constant across regimes.}
}
\value{
List with (\code{M x ar+1}) matrix of means for each regime \code{M} (where \code{M = k^(ar+1)}) and each time \code{t,... t-ar}, vector with variance for each regime \code{M}, and vector indicating the corresponded \code{1,..., k} regime.
}
\description{
This function creates a grid of mean and variance consistent with a Markov-switching autoregressive model.
}
\keyword{internal}
