% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_LRTest.R
\name{LMCLRTest}
\alias{LMCLRTest}
\title{Monte Carlo Likelihood Ratio Test}
\usage{
LMCLRTest(Y, p, k0, k1, control = list())
}
\arguments{
\item{Y}{Series to be tested. Must be a (\code{T x q}) matrix.}

\item{p}{Number of autoregressive lags. Must be greater than or equal to 0.}

\item{k0}{Number of regimes under null hypothesis. Must be greater than or equal to 1.}

\item{k1}{Number of regimes under alternative hypothesis. Must be greater than \code{k0}.}

\item{control}{List with test procedure options including: 
\itemize{
  \item N: Integer determining the number of Monte Carlo simulations. Default is set to \code{99} as in paper.
  \item burnin: Number of simulated observations to remove from beginning. Default is \code{100}.
  \item converge_check: String of NULL determining if convergence of model(s) should be verified. Allowed inputs are: "null", "alt", "both", or \code{NULL}. If \code{NULL} (default) no model convergence is verified.
  \item workers: Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open. Default is \code{0}.
  \item mdl_h0_control: List with restricted model options. See \code{\link{Nmdl}}, \code{\link{ARmdl}}, \code{\link{VARmdl}}, \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for available and default values.
  \item mdl_h1_control: List with unrestricted model options. See \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for available and default values.
  \item use_diff_init_sim: Value which determines the number of initial values to use when estimating models for null distribution. Default is set to use the same as specified in \code{mdl_h0_control} and \code{mdl_h1_control}.
}}
}
\value{
List of class \code{LMCLRTest} (\code{S3} object) with attributes including: 
\itemize{
  \item mdl_h0: List with restricted model attributes. See \code{\link{Nmdl}}, \code{\link{ARmdl}}, \code{\link{VARmdl}}, \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for return values.
  \item mdl_h0: List with unrestricted model attributes. See \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for return values.
  \item LRT_0: Value of test statistic from observed data.
  \item LRN: A (\code{N x 1}) vector of test statistics from data simulated under the null hypothesis.
  \item pval: P-value of Local Monte Carlo Likelihood Ratio Test.
  \item LRN_cv: Vector with 90\%, 95\%, and 99\% Monte Carlo critical values (from vector \code{LRN}).
  \item control: List with test procedure options used.
}
}
\description{
This function performs the Local Monte Carlo likelihood ratio 
test (LMC-LRT) proposed in Rodriguez-Rondon & Dufour (2022).
}
\examples{
set.seed(1234)
# Define DGP of MS AR process
mdl_ms2 <- list(n     = 200, 
                mu    = c(5,10),
                sigma = c(1,4),
                phi   = c(0.5),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuMSAR() function
y_ms_simu <- simuMSAR(mdl_ms2)


# ------ MS-AR example ----- #
# Set test procedure options
lmc_control = list(N = 19,
                   burnin = 100,
                   converge_check = NULL,
                   mdl_h0_control = list(const  = TRUE, 
                                         getSE  = TRUE),
                   mdl_h1_control = list(msmu   = TRUE, 
                                         msvar  = TRUE,
                                         getSE  = TRUE,
                                         method = "EM",
                                         maxit  = 300,
                                         use_diff_init = 1))

\donttest{
  lmctest <- LMCLRTest(y_ms_simu$y, p = 1, k0 = 1 , k1 = 2, lmc_control)
  summary(lmctest)
}
}
\references{
Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2022. "Simulation-Based Inference for Markov Switching Models” \emph{JSM Proceedings, Business and Economic Statistics Section: American Statistical Association}.

Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2023. “Monte Carlo Likelihood Ratio Tests for Markov Switching Models.” \emph{Unpublished manuscript}.
}
