% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{simuNorm}
\alias{simuNorm}
\title{Simulate normally distributed process}
\usage{
simuNorm(mdl_h0, burnin = 0)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item mu: A (\code{q x 1}) vector of means.
  \item sigma: A (\code{q x q}) covariance matrix.
  \item q: Number of series.
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
  \item Z: A (\code{T x qz}) matrix with exogenous regressors (Optional) and where qz is the number of exogenous variables.
  \item betaZ: A (\code{qz x q}) matrix  true coefficients on exogenous regressors (Optional) and where qz is the number of exogenous variables.
  }}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated series and its DGP parameters.
}
\description{
This function simulates a normally distributed process.
}
\examples{
set.seed(1234)
# Define DGP 
mdl_norm <- list(n     = 1000, 
                 q     = 2,
                 mu    = c(5, -2),
                 sigma = rbind(c(5.0, 1.5),
                               c(1.5, 1.0)))

# Simulate process using simuNorm() function
y_norm_simu <- simuNorm(mdl_norm)

plot(y_norm_simu)
}
