% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{create_folds}
\alias{create_folds}
\title{Create folds for cross-validation.}
\usage{
create_folds(time, delta, nfolds, foldtype = c("fullstrat",
  "censorstrat", "random"), ...)
}
\arguments{
\item{time}{a vector of event times.}

\item{delta}{a vector of indicators for uncensored/censored data. The type of censoring here is not considered so it is suggested this function not
be used for data with mixed censoring types. The specific indicator value does not matter as long as censored and uncensored observations have different
values for their indicator.}

\item{nfolds}{The number of folds to create.}

\item{foldtype}{type of cross validation folds. Full stratification, "fullstrat", sorts observations by their event time and their event indicators
and numbers them off into folds. This effectively give each fold approximately the same number of uncensored observations as well as keeps the range
of time points as equivalent as possible across folds. This type of cross-validation is completely deterministic.
Censored stratification, "censorstrat", will put approximately the same number of uncensored observations in each fold but not pay any attention to
event time. This is partially stochastic. The totally random cross-validation, "random", randomly assigns observations to folds without considering
event time nor event status.}

\item{...}{for future methods.}
}
\value{
a list of size nfolds where each list component contains the indices of the test data for each fold.
}
\description{
Create the test folds for k-fold cross validation. These cross-validation types differ from typical stratified cross-validation as this function also
considers the range of event times in the data.
}
\seealso{
\code{\link[MTLR]{mtlr_cv}}
}
