% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.list.compute.R
\name{corr.list.compute}
\alias{corr.list.compute}
\title{A Function for Creating a List of Pearson Correlation Coefficients}
\usage{
corr.list.compute(exp.mat, cn.mat, gene.annot, sample.annot = NULL)
}
\arguments{
\item{exp.mat}{A matrix of gene-level expression data (rows = genes, columns = samples).  Missing values are not permitted.}

\item{cn.mat}{A matrix of gene-level DNA copy number data (rows = genes, columns = samples).  Both genes and samples should
appear in the same order as exp.mat.  Missing values are not permitted.}

\item{gene.annot}{A three-column matrix containing gene position information.  Column 1 = chromosome number written in 
the form 'chr1' (note that chrX and chrY should be written chr23 and chr24), Column 2 = position (in base pairs), Column 3 = cytoband.
Genes should appear in the same order as exp.mat and cn.mat.}

\item{sample.annot}{An optional two-column matrix of sample annotation data.  Column 1 = sample IDs, Column 2 = sample annotation 
(e.g. tumor vs. normal).  If NULL, sample annot will be created using the common sample IDs and a single group ('1').  Default = NULL.}
}
\value{
Returns a list whose length is the number of unique groups defined by sample.annot.  Each entry in the list is the
output of corr.compute.
}
\description{
This function uses the corr.compute() function to compute gene-specific Pearson correlation coefficients in each
group of samples defined in a sample annotation matrix.
}
\examples{
output.list = exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 prepped.data = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

 pd.exp = prepped.data[["exp"]]

 pd.cn = prepped.data[["cn"]]

 pd.ga = prepped.data[["gene.annotation"]]

 pd.sa = prepped.data[["sample.annotation"]]

 corr.list.compute(pd.exp, pd.cn, pd.ga, pd.sa)

}
