% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{sample_gp}
\alias{sample_gp}
\title{Display realisations from a posterior GP}
\usage{
sample_gp(
  pred_gp,
  x_input = NULL,
  data = NULL,
  data_train = NULL,
  prior_mean = NULL,
  size_data = 3,
  size_data_train = 1,
  alpha_data_train = 0.5
)
}
\arguments{
\item{pred_gp}{A tibble or data frame, typically coming from
\code{\link{pred_magma}} or \code{\link{pred_gp}} functions. Required
columns: 'Input', 'Mean', 'Var'. Additional covariate columns may be
present in case of multi-dimensional inputs.}

\item{x_input}{A vector of character strings, indicating which input should
be displayed. If NULL(default) the 'Input' column is used for the x-axis.
If providing a 2-dimensional vector, the corresponding columns are used
for the x-axis and y-axis.}

\item{data}{(Optional) A tibble or data frame, containing the data used in
the GP prediction.}

\item{data_train}{(Optional) A tibble or data frame, containing the training
data of the Magma model. The data set should have the same format as the
\code{data} argument with an additional column 'ID' for identifying the
different individuals/tasks. If provided, those data are displayed as
backward colourful points (each colour corresponding to one
individual/task).}

\item{prior_mean}{(Optional) A tibble or a data frame, containing the 'Input'
and associated 'Output' prior mean parameter of the GP prediction.}

\item{size_data}{A number, controlling the size of the \code{data} points.}

\item{size_data_train}{A number, controlling the size of the
\code{data_train} points.}

\item{alpha_data_train}{A number, between 0 and 1, controlling transparency
of the \code{data_train} points.}
}
\value{
Draw and visualise from a posterior distribution from Magma or GP
prediction (optional: display data points, training data points and the
prior mean function).
}
\description{
A realisation of a posterior GP distribution is drawn and displayed.
According to the dimension of the inputs, the graph may be a curve or a
heatmap.
}
\examples{
TRUE
}
