% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binditmice.R
\name{binditmice}
\alias{binditmice}
\title{Binds Imputed Datasets and Dataframes}
\usage{
binditmice(datasets, data)
}
\arguments{
\item{datasets}{This argument specifies an object of the \code{mids}, \code{mimids}, or \code{wimids} class.}

\item{data}{This argument specifies a dataframe.}
}
\value{
This function returns an object of the \code{mids}, \code{mimids}, or \code{wimids} class after binding a dataframe to each imputed dataset of the inputted object.
}
\description{
The \code{binditmice()} function binds a dataframe to each imputed dataset of the \code{mids}, \code{mimids}, or \code{wimids} class objects in a row-wise fashion.
}
\details{
This functions can be used instead of the \code{cbind()} function (from the \pkg{mice} package).
}
\examples{
\donttest{
#Loading the 'dt.osa' and 'dt.osp' datasets
data(dt.osa)
data(dt.osp)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(KOA ~ SEX + AGE + SMK, datasets,
                               approach = 'within', method = 'exact')

#Binding the dataframe, 'dt.osp', to each imputed dataset of the 'matcheddatasets' object
matcheddatasets <- binditmice(matcheddatasets, dt.osp)
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchitmice]{matchitmice}}

\code{\link[=weightitmice]{weightitmice}}

\code{\link[=mergeitmice]{mergeitmice}}
}
\author{
Farhad Pishgar
}
\keyword{function}
