#### Symmetric Sparse Matrices in compressed column-oriented format

setAs("dgCMatrix", "dsCMatrix",
      function(from) {
	  if(isSymmetric(from))
	      ## FIXME: should be able to *not* need Tsparse route
	      as(as(as(from, "dgTMatrix"), "dsTMatrix"), "dsCMatrix")
	  else stop("not a symmetric matrix")})

setAs("dsCMatrix", "dsTMatrix",
      function(from) ## Cholmod:
      .Call(Csparse_to_Tsparse, from))

setAs("dsCMatrix", "dgTMatrix", # needed for image()
      function(from) ## pre-Cholmod:
      .Call(dsCMatrix_to_dgTMatrix, from))

setAs("dsCMatrix", "dgeMatrix",
      function(from) as(as(from, "dgTMatrix"), "dgeMatrix"))
setAs("dgeMatrix", "dsCMatrix",
      function(from) as(as(from, "dsyMatrix"), "dsTMatrix"))

setAs("dsCMatrix", "matrix",
      function(from) as(as(from, "dgTMatrix"), "matrix"))
setAs("matrix", "dsCMatrix",
      function(from) as(as(from, "dgTMatrix"), "dsCMatrix"))

setAs("dsCMatrix", "lsCMatrix",
      function(from) new("lsCMatrix", i = from@i, p = from@p, uplo = from@uplo,
                         Dim = from@Dim, Dimnames = from@Dimnames))

setAs("dsCMatrix", "dgCMatrix",
      function(from) .Call(sCMatrix_to_gCMatrix, from))

if(FALSE) # have 'C' version above
setAs("dsCMatrix", "dsTMatrix",
      function(from)
      new("dsTMatrix", i = from@i,
          j = .Call(Matrix_expand_pointers, from@p),
          x = from@x, uplo = from@uplo,
          Dim= from@Dim, Dimnames = from@Dimnames)
      )

setAs("dsCMatrix", "dsyMatrix",
      function(from) as(as(from, "dsTMatrix"), "dsyMatrix"))

setMethod("solve", signature(a = "dsCMatrix", b = "dgeMatrix"),
          function(a, b, ...)
          .Call(dsCMatrix_matrix_solve, a, b, TRUE),
          valueClass = "dgeMatrix")

setMethod("solve", signature(a = "dsCMatrix", b = "matrix"),
          function(a, b, ...)
          .Call(dsCMatrix_matrix_solve, a, b, FALSE),
          valueClass = "dgeMatrix")

##setMethod("solve", signature(a = "dsCMatrix", b = "numeric"),
##          function(a, b, ...) callGeneric(a, as.matrix(b)),
##          valueClass = "dgeMatrix")

setMethod("chol", signature(x = "dsCMatrix", pivot = "missing"),
          function(x, pivot, LINPACK) .Call(dsCMatrix_chol, x, TRUE))

setMethod("chol", signature(x = "dsCMatrix", pivot = "logical"),
          function(x, pivot, LINPACK) .Call(dsCMatrix_chol, x, pivot))

setMethod("t", signature(x = "dsCMatrix"),
          function(x) .Call(ssc_transpose, x),
          valueClass = "dsCMatrix")

setMethod("determinant", signature(x = "dsCMatrix", logarithm = "missing"),
          function(x, logarithm, ...) determinant(x, TRUE))

setMethod("determinant", signature(x = "dsCMatrix", logarithm = "logical"),
          function(x, logarithm, ...)
      {
          ldet <- sum(log(chol(x)@D))
          modulus <- if (logarithm) ldet else exp(ldet)
          attr(modulus, "logarithm") <- logarithm
          val <- list(modulus = modulus, sign = as.integer(1))
          class(val) <- "det"
          val
      })

setMethod("writeHB", signature(obj = "dsCMatrix"),
          function(obj, file, ...)
          .Call(Matrix_writeHarwellBoeing,
                if (obj@uplo == "U") t(obj) else obj,
                as.character(file), "DSC"))

setMethod("writeMM", signature(obj = "dsCMatrix"),
          function(obj, file, ...)
          .Call(Matrix_writeMatrixMarket,
                if (obj@uplo == "U") t(obj) else obj,
                as.character(file), "DSC"))
