% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor.R
\name{monitor_mmc}
\alias{monitor_mmc}
\title{Format the optimization method controls}
\usage{
monitor_mmc(object, alpha = NULL, monitor = TRUE)
}
\arguments{
\item{object}{A data.frame}

\item{alpha}{An atomic vector. If \code{mmc} finds a
p-value over \code{alpha}, then the algorithm will stop. This is particularly
useful if we are only looking at testing a hypothesis at a particular level.
Default is NULL.}

\item{monitor}{A logical. If set to TRUE, then the p-values at every
iteration and the cumulative maximum p-value are plotted on a graphical device.
Default is FALSE.}
}
\value{
A list. Arguments to be used to control the behavior
of the algorithm chosen in \code{method}.
}
\description{
This function provides a way to merge the user specified controls for the
optimization methods with their respective default controls.
}
\examples{
# Create empty data frame to store the p-values at the different iterations
opt_trace <- as.data.frame(matrix(data = NA, 100, 3,
                                  dimnames = list(NULL,c("ite","pval","max"))))

# Generate some random p-values
for (ite in 1:100){
    pval <- runif(1,0,.6)
    opt_trace[ite,] <- c(ite, pval, max(pval, opt_trace$pval, na.rm = TRUE))
}

# Plot p-values for every iterations
MaxMC:::monitor_mmc(opt_trace, alpha = 0.05, monitor = TRUE)

}
\keyword{internal}
