% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_findOverlappingLocations.R
\name{table_findOverlappingLocations}
\alias{table_findOverlappingLocations}
\title{Finds overlapping locations in a known locations table.}
\usage{
table_findOverlappingLocations(tbl = NULL, radius = NULL)
}
\arguments{
\item{tbl}{Tibble with \code{longitude} and \code{latitude} columns.}

\item{radius}{Radius in meters.}
}
\value{
Tibble of row indices and distances for those locations which overlap.
}
\description{
Calculates distances between all locations within a known
locations table and returns a tibble with the row indices and separation 
distances of those records with overlapping locations.

It is useful when working with new metadata tables to identify overlapping
locations early on so that decisions can be made about the apporpriateness
of the specified \code{radius}.
}
\examples{
library(MazamaLocationUtils)

meta <- wa_airfire_meta

# Anything locations closer than 2 km? (diameter = 2*radius)
table_findOverlappingLocations(meta, radius = 1000)

# How about 4 km?
table_findOverlappingLocations(meta, radius = 2000)

# Let's look at those locations

tooCloseTbl <- table_findOverlappingLocations(meta, radius = 2000)

for ( i in seq_len(nrow(tooCloseTbl)) ) {
  rows <- as.numeric(tooCloseTbl[i, 1:2])
  cat(sprintf("\n\%5.1f meters apart:\n", tooCloseTbl$distance[i]))
  print(meta[rows, c('longitude', 'latitude', 'siteName')])
}


}
