% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getLocationID.R
\name{table_getLocationID}
\alias{table_getLocationID}
\title{Return IDs of known locations}
\usage{
table_getLocationID(locationTbl = NULL, longitude = NULL,
  latitude = NULL, radius = NULL)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{longitude}{Vector of longitudes in decimal degrees E, Default: NULL}

\item{latitude}{Vector of latitudes in decimal degrees N, Default: NULL}

\item{radius}{Radius in meters, Default: NULL}
}
\value{
Vector of known \code{locationID}s.
}
\description{
Returns a vector of \code{locationID}s for the known locations
that each incoming location will be assigned to within the given. If more
than one known location exists within the given radius, the closest will be
assigned.  \code{NA} will be returned for each incoming that cannot be 
assigend to a known location in \code{locationTbl}.
}
\examples{
locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Too small a radius will not find a match
table_getLocationID(locationTbl, lon, lat, radius = 50)

# Expanding the radius will find one
table_getLocationID(locationTbl, lon, lat, radius = 5000)
}
