% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getNearestDistance.R
\name{table_getNearestDistance}
\alias{table_getNearestDistance}
\title{Return distances to nearest known locations}
\usage{
table_getNearestDistance(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Vector of target longitudes in decimal degrees E.}

\item{latitude}{Vector of target latitudes in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation.}
}
\value{
Vector of closest distances between target locations and known locations.
}
\description{
Returns distances between target locations and the closest
location found in \code{locationTbl} (if any). Target locations are specified
with \code{longitude} and \code{latitude}.

For each target location, only a single distance to the closest known location
is returned. If no known location is found within
\code{distanceThreshold}, the distance associated with that target location
will be \code{NA}. The length and order of resulting distances will match the
order of the incoming target locations.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with
\code{measure = "cheap"} will vary by a few meters compared with those
calculated using \code{measure = "geodesic"}.

See \code{geodist::\link[geodist:geodist]{geodist}} for details.
}
\section{Use Case}{

You may have a set of locations of interest for which you want to assess whether
any monitoring locations are nearby. In this case, the locations of interest
will provide \code{longitude} and \code{latitude} while \code{locationTbl}
will be the known location table associated with the monitoring locations.

The resulting vector of distances will tell you the distance, for each
target location, to the nearst monitoring location.
}

\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Too small a distanceThreshold will not find a match
table_getNearestDistance(locationTbl, lon, lat, distanceThreshold = 50)

# Expanding the distanceThreshold will find one
table_getNearestDistance(locationTbl, lon, lat, distanceThreshold = 5000)

}
