% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countyMap.R
\name{countyMap}
\alias{countyMap}
\title{County level thematic map}
\usage{
countyMap(
  data = NULL,
  parameter = NULL,
  state_SFDF = "USCensusStates_02",
  county_SFDF = "USCensusCounties_02",
  palette = "YlOrBr",
  breaks = NULL,
  style = ifelse(is.null(breaks), "pretty", "fixed"),
  showLegend = TRUE,
  legendOrientation = "vertical",
  legendTitle = NULL,
  conusOnly = TRUE,
  stateCode = NULL,
  projection = NULL,
  stateBorderColor = "gray50",
  countyBorderColor = "white",
  title = NULL
)
}
\arguments{
\item{data}{Dataframe containing values to plot. This dataframe
must contain a column named \code{countyFIPS} with the 5-digit FIPS code.}

\item{parameter}{Name of the column in \code{data} to use for
coloring the map.}

\item{state_SFDF}{simple features data frame with US states. It's data
\code{@slot} must contain a column named \code{stateCode} if either
\code{conusOnly = TRUE} or the \code{stateCode} argument is specified.}

\item{county_SFDF}{simple features data frame with US counties. It's data
\code{@slot} must always contain a column named and \code{countyFIPS} and a
column named \code{stateCode} if either \code{conusOnly = TRUE} or the
\code{stateCode} argument is specified.}

\item{palette}{Palette name or a vector of colors based on RColorBrewer or Viridis.}

\item{breaks}{Numeric vector of break points.}

\item{style}{Method to process the color scale.}

\item{showLegend}{Logical specifying whether or not to draw the legend}

\item{legendOrientation}{Orientation of the legend. Either 'vertical' or 'horizontal'}

\item{legendTitle}{Text string to use as the legend title.}

\item{conusOnly}{Logical specifying Continental US state codes. Ignored when
the \code{stateCode} argument is specified.}

\item{stateCode}{Vector of state codes to include on the map.}

\item{projection}{Specified method to represent surface of Earth.}

\item{stateBorderColor}{Color used for state borders.}

\item{countyBorderColor}{Color used for county borders.}

\item{title}{Text string to use as the plot title.}
}
\value{
A ggplot object.
}
\description{
Uses the \pkg{tmap} package to generate a thematic map at the
county level. Input consists of a dataframe with \code{countyFIPS} identifiers.
}
\details{
See \code{tmap::tm_fill()} for a more detailed description of
the following parameters:

\itemize{
\item{\code{palette}}
\item{\code{breaks}}
}
}
\note{
Color palettes can be chosen from either RColorBrewer or Viridis. See
\code{tmaptools::palette_explorer()} for a list of available palletes.
}
\examples{
\donttest{
library(MazamaSpatialPlots)

countyMap(
  data = example_US_countyCovid,
  parameter = "cases",
  breaks = c(0,100,200,500,1000,2000,5000,10000,20000,50000,1e6),
  title = "COVID-19 Cases on June 01 2020"
)

countyMap(
  data = example_US_countyCovid,
  parameter = "deaths",
  state_SFDF = USCensusStates_02,
  county_SFDF = USCensusCounties_02,
  palette = "OrRd",
  breaks = c(0, 1, 50, 100, 250, 500, 1000, 2500, 3000),
  stateCode = c( "NY", "PA", "MD", "NJ", "DE"),
  stateBorderColor = "black",
  countyBorderColor = 'grey70',
  title = "COVID-19 Deaths* in the Mid Atlantic"
) +
  tmap::tm_layout(
    main.title.size = 1.2,
    main.title.color = "white",
    attr.color = 'white',
    bg.color = "dodgerblue4"
  ) +
  tmap::tm_credits("*as of June 01, 2020", col = "white", position = "left")
}
}
